#include "Player.h"

#define FIRE_TIMEOUT 0.5f

Player :: Player(float posx,float posy,float angle) {
   setPos(posx,posy);
   setWheelPosAgainstCenter();
   setId(-1);
   this->turret_angle = angle;   
   jumping = false;
   face_to_right = true;
   reset();
}

Player :: ~Player() {
}

void Player :: init() {
   vmodel = ObjLoader::instance()->load("data/vehicle.obj");
   wmodel = ObjLoader::instance()->load("data/wheel.obj");
   vmodel->build();
   wmodel->build();

   //sm = MS3DLoader::instance()->load("data/bomber_run.ms3d");
   amodel = MD2Loader::instance()->load("data/tris.md2","data/blue.bmp");
   amodel->build();
   amodel->activeAnimation(2);

}

void Player :: reset() {
   if (id == 0)
      setColor(0.0f,0.0f,1.0f);
   else
      setColor(1.0f,0.0f,0.0f);
   setEnergy(MAX_ENERGY);
   setAmmo(MAX_AMMO);
   setSteerEnergy(50.0f);
   setThrowForce(0.1f);
   setScore(0);
   setSpeed(2.0f);
   fireTimeout = -1;
   turret_angle = 0;
   jumpcnt = 0;
      
}

void Player :: setPos(float x,float y) {
   posx = x;
   posy = y;
}

void Player :: setWheelPosAgainstCenter() {
   int centerw = wheel_cnt/2;
   int w=0;
   for (int i=-centerw;i<=centerw;++i,++w) {
      wheelposx[w] = posx + wheel_pos_offset * i;
      wheelposy[w] = posy;
   }
}

void Player ::  getWheelPos(float *wposx,float *wposy) {
   memcpy(wposx,wheelposx,sizeof(wheelposx));
   memcpy(wposy,wheelposy,sizeof(wheelposy));
}

void Player ::  setWheelPos(const float *wposx,const float *wposy) {
   memcpy(wheelposx,wposx,sizeof(wheelposx));
   memcpy(wheelposy,wposy,sizeof(wheelposy));
   
   int centerw = wheel_cnt/2;
   int lastw   = wheel_cnt-1;
   int firstw  = 0;
   float dy1 = wheelposy[centerw] - wheelposy[lastw];
   float dx1 = wheelposx[lastw] - wheelposx[centerw];
   float a1 = atan2(dy1,dx1);
   float dy2 = wheelposy[centerw] - wheelposy[firstw];
   float dx2 = wheelposx[centerw] - wheelposx[firstw];
   float a2 = -atan2(dy2,dx2);
   body_angle = RToD((a1+a2)*0.5f);
}

void Player :: setColor(float r,float g,float b) {
   colr = r;
   colg = g;
   colb = b;
}

void Player :: setThrowForce(float tf) {
   if (tf >= 0.1f && tf <= 1.0f)
      throw_force = tf;
}

bool Player :: checkCollision(float x,float y,float r) {
   float dx = posx - x;
   float dy = posy - y;
   if ((dx*dx+dy*dy) < (PLAYER_R+r)*(PLAYER_R+r))
      return true;
   else
   return false;
}

void Player :: turnTurret(float deg) {
   turret_angle += deg;
}

void Player :: weaponFired() {
   fireTimeout = FIRE_TIMEOUT;
}

void Player :: update(float dt) {

   static float elapsed = 0;
   elapsed += dt;
   
   if (steer_energy < 1.0f) {
      steer_energy += dt * 0.09f;
   }

   fireTimeout -= dt;

   if (jumping) {
      
      setPos(posx + dt * jumpForce[0],posy + dt * jumpForce[1]);
      
      //jumpForce[0] -= dt * 10;
      jumpForce[1] -= dt * 10;
   }

   amodel->animate(dt);
}

void Player :: beginJump(float forcex,float forcey) {

   if (jumpcnt < MAX_JUMP) {
   
      jumpForce[0] = forcex;
      jumpForce[1] = forcey;
      jumping = true;

      ++jumpcnt;

   }

}

void Player :: render(float r,float g,float b) {
   
     
   glPushMatrix();
   
   // render energy, steer_energy, throw_force
   glLineWidth(2.0f);
   glPushMatrix();
   glTranslatef(posx,posy+0.1f,0);   
   
   //if (jumping == false)
   //   glRotatef(-body_angle,0,0,1);

   int f;
   if (face_to_right)
      f = 1;
   else
      f = -1;
   
   glScalef(f * vehicle_scale*1*0.1,vehicle_scale*1*0.1,0.01f);
   glColor3f(r,g,b);   
   
   //vmodel->render();
   //glRotatef(90,0,1,0);
   amodel->render();
   
   glPopMatrix();

   /*
   glColor3f(1,0,0);
   glBegin(GL_LINES);
   glVertex2f(posx,posy+0.7f);
   glVertex2f(posx+energy*0.02f,posy+0.7f);
   glColor3f(0,0,1);
   glVertex2f(posx,posy+0.8f);
   glVertex2f(posx+steer_energy*0.02f*10,posy+0.8f);
   glColor3f(0,1,0);
   glVertex2f(posx,posy+0.9f);
   glVertex2f(posx+throw_force*0.02f*10,posy+0.9f);
   glEnd();
   */
   glPopMatrix();
   
   glLineWidth(1.0f);
   
   //glEnable(GL_BLEND);
   //glBlendFunc(GL_ONE,GL_ONE_MINUS_SRC_ALPHA);
  
   glPushMatrix();
   glTranslatef(posx,posy+0.3f,0);
   
   glRotatef(turret_angle,0,0,1);

   glScalef(vehicle_scale*0.05f * 10,vehicle_scale*0.05f  *10,vehicle_scale);
   
   //glColor3f(132.0f/255.0f,150.0f/255.0f,156.0f/255.0f);

   const float turretlen = 6.0f;
   
   glTranslatef(-throw_force*3,0,0);
   
   glBegin(GL_QUADS);
   glColor3f(colr,colg,colb); glVertex2f(turretlen,1);
   glColor3f(colr,colg,colb); glVertex2f(0,1);
   glColor3f(colr/2,colg/2,colb/2); glVertex2f(0,-1);
   glColor3f(colr/2,colg/2,colb/2); glVertex2f(turretlen,-1);
   glEnd();

   glColor3f(1,0,0);

   glBegin(GL_QUADS);
   glVertex2f(turretlen,-1);
   glVertex2f(turretlen+1,-1);
   glVertex2f(turretlen+1,1);
   glVertex2f(turretlen,1);
   glEnd();

   glPopMatrix();

   glPopMatrix();

}
